IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_EXCLUI_PEDENCIA'AND TYPE = 'TR')
BEGIN
	DROP TRIGGER dbo.TRG_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_EXCLUI_PEDENCIA 
END
GO

CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_EXCLUI_PEDENCIA] ON [dbo].[EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT] FOR  INSERT AS
BEGIN

	
	--Excluindo Pedencia de arquivo DANFE para pedente
	DELETE p
		FROM EST_NF_ENT_DANFE_PROVISORIO_PENDENTE p 
		INNER JOIN INSERTED i ON
		p.CD_CTR = i.CD_CTR

		/*
	O JOB ESTA FAZENDO ESTE SERVICO
	--Excluindo Pedencia de liberacao de nf
	DELETE p
		FROM EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE p 
		INNER JOIN INSERTED i ON
		p.CD_CTR = i.CD_CTR
				
	-- Sem pedido	
	DELETE p
		FROM EST_NF_ENT_DANFE_PROVISORIO_SEM_PEDIDO p 
		INNER JOIN INSERTED i ON
		p.CD_CTR = i.CD_CTR
		*/

	--Criando relacionamento com o arquivo de danfe
	UPDATE 
		d
	SET
		d.CD_EMP = i.CD_EMP,
		d.CD_FILIAL = i.CD_FILIAL,
		d.CD_NF = i.CD_NF
	FROM
		INSERTED i 
		INNER JOIN EST_NF_ENT_ARQ_DANFE d ON
		i.CD_CTR = d.CD_CTR_DANFE_PROV


	--Pedencia de confirmacao de operacao
	INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_CONFIRMACAO_OPERACAO_PENDENTE
	(CD_EMP,
	CD_FILIAL,
	CD_NF,
	CD_CTR, 
	DT_CAD)
	SELECT 
		DISTINCT i.CD_EMP,
		i.CD_FILIAL,
		i.CD_NF,
		i.CD_CTR, 
		GETDATE()	
	FROM 
		INSERTED i LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_CONFIRMACAO_OPERACAO_PENDENTE p ON
		i.CD_CTR = p.CD_CTR 
	WHERE
		p.CD_CTR IS NULL;
END 


